﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Context" xmlns="http://purl.oclc.org/dsdl/schematron">
  <title>Context Validations</title>
  
  <rule context="xbrli:xbrl">
    
    <!-- Rule ID: VR.SS.CMV.000001
      
    IF COUNT(MessageSender) = 0
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000001" diagnostics="DVR.SS.CMV.000001" test="not(
      not($RP.MessageSender.Context)
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000002
      
    IF COUNT(MessageSender) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000002" diagnostics="DVR.SS.CMV.000002" test="not(
      count($RP.MessageSender.Context) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000003
      
    IF COUNT(MessageReceiver) = 0
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000003" diagnostics="DVR.SS.CMV.000003" test="not(
      not($RP.MessageReceiver.Context)
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000004
      
    IF COUNT(MessageReceiver) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000004" diagnostics="DVR.SS.CMV.000004" test="not(
      count($RP.MessageReceiver.Context) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000005
      
    IF COUNT(Employer) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000005" diagnostics="DVR.SS.CMV.000005" test="not(
      count($RP.Employer.Context) &gt; 1
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000006
      
    IF COUNT(Employer) = 0
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000006" diagnostics="DVR.SS.CMV.000006" test="not(
      not($RP.Employer.Context)
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000008
      
    IF COUNT(SuperFundMember) = 0
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000008" diagnostics="DVR.SS.CMV.000008" test="not(
      not($RP.SuperFundMember.Context)
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000010
      
    IF COUNT(SuperFundMember) > 1
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000010" diagnostics="DVR.SS.CMV.000010" test="not(
      count($RP.SuperFundMember.Context) &gt; 1
    )" />
    
  </rule>

  <rule context="xbrli:xbrl/xbrli:context[not(@i:nil='true')]">
    <let name="thisContextId" value="@id" />
    <let name="thisIdentifier" value="xbrli:entity/xbrli:identifier"/>
    
    <!-- Rule ID: VR.SS.GEN.100002
      
    IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.xx.xx:MessageSender) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.100002" diagnostics="DVR.SS.GEN.100002" test="not(
      xbrli:entity/xbrli:segment/xbrldi:explicitMember
      [      
        not(@i:nil='true') 
        and ends-with(@dimension, 'ReportPartyTypeDimension')
        and ends-with(., 'MessageSender')
      ]
      and
      xbrli:entity/xbrli:identifier
      [
        not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
      ]
    )" />
    
    <!-- Rule ID: VR.SS.GEN.100003
      
    IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.xx.xx:MessageReceiver) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.100003" diagnostics="DVR.SS.GEN.100003" test="not(
      xbrli:entity/xbrli:segment/xbrldi:explicitMember
      [      
        not(@i:nil='true') 
        and ends-with(@dimension, 'ReportPartyTypeDimension')
        and ends-with(., 'MessageReceiver')
      ]
      and
      xbrli:entity/xbrli:identifier
      [
        not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
      ]
    )" />

    <!-- Rule ID: VR.SS.GEN.200006
    
    IF (RP.SUPERFUNDMEMBER:xbrli:identifier scheme <> "http://www.ato.gov.au/tfn") and (RP.SUPERFUNDMEMBER:xbrli:identifier scheme <> "http://www.sbr.gov.au/id")
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.GEN.200006" diagnostics="DVR.SS.GEN.200006" test="not(
      exists($RP.SuperFundMember.Context[generate-id() = generate-id(current())])
      and
      xbrli:entity/xbrli:identifier
      [
        not(matches(@scheme, '^http://www.ato.gov.au/tfn$')
        or
        matches(@scheme, '^http://www.sbr.gov.au/id$'))
      ]
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000007
      
    IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.xx.xx:Employer) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000007" diagnostics="DVR.SS.CMV.000007" test="not(
      xbrli:entity/xbrli:segment/xbrldi:explicitMember
      [      
        not(@i:nil='true') 
        and ends-with(@dimension, 'ReportPartyTypeDimension')
        and ends-with(., 'Employer')
      ]
      and
      xbrli:entity/xbrli:identifier
      [
        not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
      ]
    )" />
    
    <!-- Rule ID: VR.SS.CMV.000009
      
    IF(xbrli:identifier scheme ="http://www.ato.gov.au/tfn") and (TFNALGORITHM(xbrli:identifier) = FALSE)
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000009" diagnostics="DVR.SS.CMV.000009" test="not(
      xbrli:entity/xbrli:identifier
      [
        matches(@scheme, '^http://www.ato.gov.au/tfn$')
        and not(function:ValidateTFN(.))
      ]
    )" />

    <!-- Rule ID: VR.SS.CMV.000040
      
    IF ABNALGORITHM(MessageReceiver:xbrli:identifier) = FALSE
      RETURN VALIDATION MESSAGE
    ENDIF
    -->
    <assert id="VR.SS.CMV.000040" diagnostics="DVR.SS.CMV.000040" test="not(
      exists($RP.MessageReceiver.Context[generate-id() = generate-id(current())])
      and
      xbrli:entity/xbrli:identifier
      [
        not(function:ValidateABN(.))
      ]
    )" />

  </rule>

  <rule context="xbrldi:typedMember[not(@i:nil='true') and ends-with(@dimension,'SuperFundABNDimension')]/*">
    <!-- Rule ID: VR.SS.GEN.200008
        
    IF (ABNALGORITHM (SprFndAbn.02.00:SuperFundABNDimension:SprFndAbn.02.00:Identifiers.AustralianBusinessNumber.Identifier) = FALSE)
      RETURN VALIDATION MESSAGE
    END IF
    -->
    <assert id="VR.SS.GEN.200008" diagnostics="DVR.SS.GEN.200008" test="not(
      name() = 'SprFndAbn.02.00:Identifiers.AustralianBusinessNumber.Identifier'
      and
      not(function:ValidateABN(.)) 
    )"/>
  </rule>
</pattern>